/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.convenientdecor.block.blockentity;

import com.github.mim1q.convenientdecor.init.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class PlushieBlockEntity
extends BlockEntity {
    private float rotation = 0.0f;
    private long squishTime = 0L;

    public PlushieBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.PLUSHIE, pos, state);
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
        this.m_6596_();
    }

    public void squish(Level world, SoundEvent sound, long time) {
        if (time - this.squishTime > 5L) {
            world.m_5594_(null, this.f_58858_, sound, SoundSource.BLOCKS, 0.2f, 1.0f + world.f_46441_.m_188501_() * 0.1f);
            this.squishTime = time;
        }
    }

    public float getSquish(float time) {
        float t = (time - (float)this.squishTime) / 10.0f;
        if (t < 0.0f) {
            return 1.0f;
        }
        if (t > 1.0f) {
            return 0.0f;
        }
        return (float)(Math.pow(2.0, -10.0 * (double)t) * Math.sin(((double)t - 0.075) * (Math.PI * 2) / 0.3));
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128350_("rotation", this.rotation);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.rotation = nbt.m_128457_("rotation");
    }
}

